% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_kegg_sets}
\alias{get_kegg_sets}
\title{Retrieves KEGG pathway gene sets for a specified organism and gene ID type.}
\usage{
get_kegg_sets(organism = "hsa", geneid_type = "entrez")
}
\arguments{
\item{organism}{The organism abbreviation for which KEGG pathway gene sets are to be retrieved (e.g., "ecj" for E. coli). Default is "hsa" (Homo sapiens).}

\item{geneid_type}{The type of gene IDs to provide. Default is "entrez"; options are "entrez", "symbol", or "ensembl". 
This parameter is only used when the organism is "hsa" (Homo sapiens).}
}
\value{
A list where each element represents a KEGG pathway gene set. The names of the list correspond to the pathway names.
}
\description{
This function retrieves KEGG pathway gene sets for a specified organism. 
It fetches all pathways available for the specified organism from the KEGG database and maps the genes involved in each pathway. 
Currently, the function only supports choice of gene identifiers (entrez IDs, gene symbols or Ensembl IDs) for Homo sapiens (organism = "hsa") using the org.Hs.eg.db package.
}
\examples{
# Retrieve KEGG pathway gene sets for Homo sapiens with entrez IDs (default)
hsa_kegg_sets_entrez <- get_kegg_sets()

# Retrieve KEGG molecular sets using gene symbols
hsa_kegg_sets_symbol <- get_kegg_sets(geneid_type = "symbol")

# Retrieve KEGG molecular sets using Ensembl IDs
hsa_kegg_sets_ensembl <- get_kegg_sets(geneid_type = "ensembl")

# Retrieve KEGG pathway gene sets for another organism (e.g., Escherichia coli)
ecoli_kegg_sets <- get_kegg_sets(organism = "ecj")

}
\seealso{
\code{\link{summarize_pathway_level}}

\code{\link{keggLink}}, \code{\link{keggList}}

\code{\link{mapIds}}
}
