% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatingSet_Methods.R, R/GatingSetList_Methods.R
\name{recompute}
\alias{recompute}
\alias{recompute.GatingSet}
\alias{recompute.GatingSetList}
\title{Compute the cell events by the gates stored within the gating tree.}
\usage{
recompute(
  x,
  y = "root",
  alwaysLoadData = FALSE,
  verbose = FALSE,
  leaf.bool = TRUE
)

\method{recompute}{GatingSet}(
  x,
  y = "root",
  alwaysLoadData = FALSE,
  verbose = FALSE,
  leaf.bool = TRUE
)

\method{recompute}{GatingSetList}(x, ...)
}
\arguments{
\item{x}{\code{GatingSet or GatingSetList}}

\item{y}{\code{character} node name or node path. Default "root". Optional.}

\item{alwaysLoadData}{\code{logical}. Specifies whether to load the flow raw data for gating boolean gates. Default 'FALSE'. Optional. Sometime it is more efficient to skip loading the raw data if all the reference nodes and parent are already gated. 'FALSE' will check the parent node and reference to determine whether to load the data.
This check may not be sufficient since  the further upstream ancestor nodes may not be gated yet.
In that case, we allow the gating to fail and prompt user to recompute those nodes explictily.
 When TRUE, then it forces data to be loaded to guarantee the gating process to be uninterrupted at the cost of unnecessary data IO.}

\item{verbose}{default is FALSE}

\item{leaf.bool}{whether to compute the leaf boolean gate, default is TRUE}

\item{...}{arguments}
}
\description{
Compute each cell event to see if it falls into the gate stored within the gating tree
and store the result as cell count.
}
\details{
It is usually used immediately after \link{add} or \link{gs_pop_set_gate} calls.
}
