% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow_trans.R
\name{logicleGml2_trans}
\alias{logicleGml2_trans}
\title{GatingML2 version of logicle transformation.}
\usage{
logicleGml2_trans(
  T = 262144,
  M = 4.5,
  W = 0.5,
  A = 0,
  n = 6,
  equal.space = FALSE
)
}
\arguments{
\item{T, M, W, A}{see \link{logicletGml2}}

\item{n}{desired number of breaks (the actual number will be different depending on the data range)}

\item{equal.space}{whether breaks at equal-spaced intervals}
}
\value{
a logicleGml2 transformation object
}
\description{
The only difference from \link{logicle_trans} is it is scaled to c(0,1) range.
}
\examples{
trans.obj <- logicleGml2_trans(equal.space = TRUE)
data <- 1:1e3
brks.func <- trans.obj[["breaks"]]
brks <- brks.func(data)
brks # logicle space displayed at raw data scale
#transform it to verify the equal-spaced breaks at transformed scale
print(trans.obj[["transform"]](brks))
}
