% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_GatingSet.R
\name{gs_split_by_channels}
\alias{gs_split_by_channels}
\alias{groupByChannels}
\title{split GatingSets into groups based on their flow channels}
\usage{
gs_split_by_channels(x)
}
\arguments{
\item{x}{a list of GatingSets}
}
\description{
Sometime it is gates are defined on the different dimensions
across different GatingSets, (e.g. `FSC-W` or `SSC-H` may be used for Y axis for cytokines)
These difference in dimensions may not be critical since they are usually just used for visualization(istead of thresholding events)
But this prevents the gs from merging because they may not be collected across batces
Thus we have to separate them if we want to visualize the gates.
}
\examples{
\dontrun{
gslist <- list(gs1, gs2, gs3, gs4, gs5)
gs_groups <- gs_split_by_channels(gslist)
}
}
