% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_gs.R
\name{convert_legacy_gs}
\alias{convert_legacy_gs}
\alias{convert_legacy_gslist}
\title{convert the legacy GatingSet archive (mixed with R and C++ files) to the new format (C++ only)}
\usage{
convert_legacy_gs(from, to, ...)

convert_legacy_gslist(from, to, ...)
}
\arguments{
\item{from}{the old archive path}

\item{to}{the new archive path}

\item{...}{tmp the path where the temporary files will be written to during the conversion. By default it is system temp folder and
sometime it is helpful to be able to customize it to other location when system temp folder is fulll or not succicient when
 converting big data sets.}
}
\description{
Older versions of flowWorkspace represented \code{\link{GatingSet-class}} objects using a combination of
R and C++ files, while newer versions have moved the representation entirely to the C++ level for
the sake of efficiency. In order to use \code{GatingSet} or \code{GatingSetList} archives created in older versions, 
they will need to be converted to the new format.
}
\details{
Note that it is likely some of the keyword values (mainly offsets e.g. BEGINDATA) may change slightly after the conversion 
due to the process of rewriting data to FCS files through write.FCS.
}
\examples{
\dontrun{
convert_legacy_gs(old_gs_path, new_gs_path)
}
}
