% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlowHist.R
\name{pickInit}
\alias{pickInit}
\title{Interactively select model starting values}
\usage{
pickInit(fh)
}
\arguments{
\item{fh}{A \code{\link{FlowHist}} object}
}
\value{
\code{\link{pickInit}} returns the \code{\link{FlowHist}} object
  with its initial value slot updated.
}
\description{
Prompts the user to select the peaks to use as initial
  values for non-linear regression on a plot of the histogram data.
}
\details{
The raw histogram data are plotted, and the user is prompted to
  select the peak positions to use as starting values in the NLS
  procedure. This is useful when the automated peak-finding algorithm
  fails to discriminate between overlapping peaks, or is confused by
  noise.

Note that the A peak must be lower (smaller mean, further left) than the
B peak. If the user selects the A peak with a higher mean than the B
peak, the peaks will be swapped to ensure A is lower.
}
\examples{
library(flowPloidyData) 
fh2 <- FlowHist(file = flowPloidyFiles()[2], channel = "FL3.INT.LIN")
plot(fh2, init = TRUE) ## automatic peak estimates
\dontrun{
fh2 <- pickInit(fh2)   ## hand-pick peak estimates
}
plot(fh2, init = TRUE) ## revised starting values
}
\author{
Tyler Smith
}
