% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_graph.R
\name{get_phen_meta}
\alias{get_phen_meta}
\title{Genrates phenotype meta data.}
\usage{
get_phen_meta(phen, phenocode = NULL)
}
\arguments{
\item{phen}{A string vector of phenotype or cell population name labels.}

\item{phenocode}{A string vector of phenocodes corresponding
to the phenotypes in \code{phen}.}
}
\value{
A data frame with columns containing meta data on
   cell poulation nodes with columns:
   \itemize{
       \item{\code{phenotype}: cell population node label e.g. "A+B+".}
       \item{\code{phenocode}: a string penocode containing a numeric
        corresponding to the phenotype column e.g. "2200".}
       \item{\code{phenolayer}: a numeric layer on which a cell population
        resides in e.g. 2.}
   }
}
\description{
Generates phenotype meta data given a vector of
   phenotypes and optionally phenocodes.
}
\examples{

   phen <- c('A+B+C-D++', 'A+B-', '', 'B++D-E+')
   phenc <- c('22130','21000','00000','03012')
   get_phen_meta(phen, phenc)

}
\seealso{
\code{\link[flowGraph]{get_phen_list}}
   \code{\link[flowGraph]{cell_type_layers}}
}
