% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_modifiers.R
\name{fg_merge_samples}
\alias{fg_merge_samples}
\title{Merges the samples from two flowGraph objects.}
\usage{
fg_merge_samples(fg1, fg2)
}
\arguments{
\item{fg1}{flowGraph object.}

\item{fg2}{flowGraph object.}
}
\value{
flowGraph object.
}
\description{
Merges the samples from two flowGraph objects together;
 we recommend removing all summary statistics from the new flowGraph object
 as those won't be adjusted: \code{\link[flowGraph]{fg_clear_summary}}.
}
\details{
Appends the samples from \code{fg2} onto those in \code{fg1}.
 This function requires that the two flowGraph objects must have the
 same phenotypes. Therefore, we recommend users to use,
 instead, \code{\link[flowGraph]{fg_merge}}.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg0 <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 prop=FALSE, specenr=FALSE,
                 no_cores=no_cores)

 fg1 <- fg_extract_samples(fg0, fg_get_meta(fg0)$id[1:5])
 fg2 <- fg_extract_samples(fg0, fg_get_meta(fg0)$id[4:7])
 fg <- fg_merge_samples(fg1, fg2)
 fg_get_feature_desc(fg)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_get_feature_desc}}
 \code{\link[flowGraph]{fg_merge}}
 \code{\link[flowGraph]{fg_extract_samples}}
}
