% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_modifiers.R
\name{fg_gsub_markers}
\alias{fg_gsub_markers}
\title{Replace marker names.}
\usage{
fg_gsub_markers(fg, markers_new, markers_old = NULL)
}
\arguments{
\item{fg}{flowGraph object.}

\item{markers_new}{A string vector of new marker names;
if \code{markers_old} is set to \code{NULL},
each marker in \code{markers_new} should correspond to
each marker in the \code{markers} slot of the \code{flowGraph} object.}

\item{markers_old}{A string vector of old marker names user wants to replace;
these marker names corresponding to those
in \code{fg_get_markers(fg)} with the same length as \code{markers_new}.
If \code{markers_old=NULL}, \code{markers_new} should be the same length as
\code{fg_get_markers(fg)}.}
}
\value{
flowGraph object with marker names replaced.
}
\description{
Replace marker names in a flowGraph object.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 prop=FALSE, specenr=FALSE,
                 no_cores=no_cores)

 fg <- fg_gsub_markers(fg, c("Anew", "Bnew", "Cnew", "Dnew"))
 fg_get_feature_desc(fg)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_gsub_ids}}
}
