% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{logTransform}
\alias{logTransform}
\title{Create the definition of a log transformation function (base specified by
user) to be applied on a data set}
\usage{
logTransform(transformationId="defaultLogTransform", logbase=10, r=1, d=1)
}
\arguments{
\item{transformationId}{character string to identify the transformation}

\item{logbase}{positive double that corresponds to the base of the
logarithm.}

\item{r}{positive double that corresponds to a scale factor.}

\item{d}{positive double that corresponds to a scale factor}
}
\value{
Returns an object of class \code{transform}.
}
\description{
Create the definition of the log Transformation that will be applied on some
parameter via the \code{transform} method.  The definition of this function
is currently x<-log(x,logbase)*(r/d).  The transformation would normally be
used to convert to a linear valued parameter to the natural logarithm scale.
Typically r and d are both equal to 1.0. Both must be positive.  logbase =
10 corresponds to base 10 logarithm.
}
\examples{

samp <- read.FCS(system.file("extdata",
   "0877408774.B08", package="flowCore"))
  logTrans <- logTransform(transformationId="log10-transformation", logbase=10, r=1, d=1)
  trans <- transformList('FSC-H', logTrans)
  dataTransform <- transform(samp, trans)

}
\seealso{
\code{\link{transform-class}}, \code{\link{transform}}

Other Transform functions: 
\code{\link{arcsinhTransform}()},
\code{\link{biexponentialTransform}()},
\code{\link{inverseLogicleTransform}()},
\code{\link{linearTransform}()},
\code{\link{lnTransform}()},
\code{\link{logicleTransform}()},
\code{\link{quadraticTransform}()},
\code{\link{scaleTransform}()},
\code{\link{splitScaleTransform}()},
\code{\link{truncateTransform}()}
}
\author{
B. Ellis, N. LeMeur
}
\concept{Transform functions}
\keyword{methods}
