% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowFrame-accessors.R
\docType{methods}
\name{decompensate}
\alias{decompensate}
\alias{decompensate,flowFrame,matrix-method}
\alias{decompensate,flowFrame,data.frame-method}
\alias{decompensate-methods}
\alias{decompensate,flowFrame,compensation-method}
\title{Decompensate a flowFrame}
\usage{
\S4method{decompensate}{flowFrame,matrix}(x, spillover)

\S4method{decompensate}{flowFrame,compensation}(x, spillover)
}
\arguments{
\item{x}{flowFrame.}

\item{spillover}{matrix or data.frame or a compensation object}
}
\value{
a decompensated flowFrame
}
\description{
Reverse the application of a compensation matrix on a flowFrame
}
\examples{
library(flowCore)
f = list.files(system.file("extdata",
   "compdata",
   "data",
   package="flowCore"),
 full.name=TRUE)[1]
f = read.FCS(f)
spill = read.csv(system.file("extdata",
       "compdata", "compmatrix",
        package="flowCore"), 
        ,sep="\t",skip=2)
colnames(spill) = gsub("\\\\.","-",colnames(spill))
f.comp = compensate(f,spill)
f.decomp = decompensate(f.comp,as.matrix(spill))
sum(abs(f@exprs-f.decomp@exprs))
all.equal(decompensate(f.comp,spill)@exprs,decompensate(f.comp,as.matrix(spill))@exprs)
all.equal(f@exprs,decompensate(f.comp,spill)@exprs)

}
