% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parseChromaTOF}
\alias{parseChromaTOF}
\title{Parser for ChromaTOF files}
\usage{
parseChromaTOF(
  fn,
  min.pc = 0.01,
  mz = seq(85, 500),
  rt.cut = 0.008,
  rtrange = NULL,
  skip = 1,
  rtDivide = 60
)
}
\arguments{
\item{fn}{ChromaTOF filename to read.}

\item{min.pc}{minimum percent of maximum intensity.}

\item{mz}{vector of mass-to-charge bins of raw data table.}

\item{rt.cut}{the difference in retention time, below which peaks are merged
together.}

\item{rtrange}{retention time range to parse peaks from, can speed up
parsing if only interested in a small region (must be \code{numeric} vector
of length 2)}

\item{skip}{number of rows to skip at beginning of the ChromaTOF}

\item{rtDivide}{multiplier to divide the retention times by (default: 60)}
}
\value{
\code{list} with components \code{peaks} (table of spectra -- rows are
mass-to-charge and columns are the different detected peaks) and \code{tab}
(table of features for each detection), according to what is stored in the
ChromaTOF file.
}
\description{
Reads ASCII ChromaTOF-format files from AMDIS (Automated Mass Spectral
Deconvolution and Identification System)
}
\details{
\code{parseChromaTOF} will typically be called by
\code{\link{addChromaTOFPeaks}}, not called directly.

Peaks that are detected within \code{rt.cut} are merged together.  This
avoids peaks which are essentially overlapping.

Fragments that are less than \code{min.pc} of the maximum intensity fragment
are discarded.
}
\examples{

require(gcspikelite)

# paths and files
gcmsPath<-paste(find.package("gcspikelite"),"data",sep="/")
tofFiles<-dir(gcmsPath,"tof",full=TRUE)

# parse ChromaTOF file
cTofList<-parseChromaTOF(tofFiles[1])

}
\references{
Mark D Robinson (2008).  Methods for the analysis of gas chromatography -
mass spectrometry data \emph{PhD dissertation} University of Melbourne.
}
\seealso{
\code{\link{addAMDISPeaks}}
}
\author{
Mark Robinson
}
\keyword{manip}
