% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getdrop1ranks.R
\name{getdrop1ranks}
\alias{getdrop1ranks}
\title{Derive ranking lists including original and leave-one-out rankings}
\usage{
getdrop1ranks(X, y, fun, decreasing = FALSE, topN = 100, nCores = NULL)
}
\arguments{
\item{X}{A data matrix, with rows being the variables and columns being
samples.}

\item{y}{Groups or survival object (for cox regression)}

\item{fun}{\emph{fun} can either be a character or a function. \emph{fun} should be one
of the 't.test', 'cox', 'log2fc', and 'kruskal.test' when it is a character.
\code{findIPs()} incorporates four widely used ranking criteria: t-test,
univariate cox model, log2fc, and kruskal test, whose outputs are p values
except log2fc (absolute log2 fold changes). The features would be ordered by
specifying the argument \code{decreasing}. For instance,
if \code{fun = 't.test'}, the \code{decreasing = F}, such that features are
order by the pvalues of t.test in the increasing manner.

\emph{fun} can also be a function to obtain ranking criteria with x and y being
the only input and the ranking criteria, such as p-values being the only
output.}

\item{decreasing}{logical. How the rank criteria are ordered? For instance,
p-value should be ordered increasingly, while fold-change should be ordered
decreasingly.}

\item{topN}{the number of important features included for comparison.
The top n features in the original ranking list.}

\item{nCores}{the number of CPU cores used for parallel running.
If nCores = NULL, a single core is used.}
}
\value{
\item{orig}{vector:,original ranking}

\item{drop1rank}{matrix, Leave-one-out rankings}
}
\description{
This function calculates the original and leave-one-out feature rankings
using a predefined rank method
}
\examples{

data(miller05)
X <- miller05$X
y <- miller05$y
obj <- getdrop1ranks(X, y,
                     fun = 't.test',
                     decreasing = FALSE,
                     topN = 100)
rks <- sumRanks(origRank = obj$origRank,
                drop1Rank = obj$drop1Rank,
                topN = 100,
                method = 'adaptive')
plotIPs(rks, topn = 5, ylim = NULL)

}
