% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geseca-plot.R
\name{plotCoregulationProfileImage}
\alias{plotCoregulationProfileImage}
\title{Spatial visualization of GESECA scores for individual cells}
\usage{
plotCoregulationProfileImage(
  pathway,
  object,
  title = NULL,
  assay = DefaultAssay(object),
  colors = rdbuColors,
  guide = "colourbar",
  minLimit = -3,
  maxLimit = 3,
  ...
)
}
\arguments{
\item{pathway}{Gene set (vector of gene names) or a named list of gene sets to plot.
If a list is provided, each element is treated as a separate pathway and yields its own plot.}

\item{object}{Seurat object}

\item{title}{Optional title for the plot. If `pathway` is a list,
`title` should be a character vector of the same length; otherwise, the list element names are used.}

\item{assay}{assay to use for obtaining scaled data, preferably with
the same universe of genes in the scaled data}

\item{colors}{vector of colors to use in the color scheme (default is similar to "RdBu" Brewer's color palette)}

\item{guide}{option for `ggplot2::scale_color_gradientn` to control for presence of the color legend
the same universe of genes in the scaled data}

\item{minLimit}{Numeric value specifying the minimum limit for the color scale.
This defines the lower bound of the z-score used in coloring the feature plot.
Values below this limit are squished to the minimum color.}

\item{maxLimit}{Numeric value specifying the maximum limit for the color scale.
This defines the upper bound of the z-score used in coloring the feature plot.
Values above this limit are squished to the maximum color.}

\item{...}{Additional arguments passed to \link[Seurat]{ImageFeaturePlot}}
}
\value{
ggplot object (or a list of objects) with the spatial image plot of scaled geseca scores

When the input is a list of pathways, pathway names are used for titles.
A list of ggplot objects a returned in that case.
}
\description{
This function computes GESECA scores for one or more gene sets and overlays those scaled scores onto the spatial image.
}
