% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignTax.R
\name{assignTax}
\alias{assignTax}
\title{Taxonomic Classification}
\usage{
assignTax(fasta, template = NULL, taxonomy = NULL, ksize = 8, iters = 100, cutoff = 80,
processors = 1, dir.out = "assignTax_out")
}
\arguments{
\item{fasta}{a fasta file of rRNA sequences to be assigned with taxonomies, e.g. a set of sequences picked as the representatives of OTUs.}

\item{template}{a faste file of rRNA reference sequences, default to download "Silva_119_provisional_release.zip" under "qiime" directory from SILVA archive under , and extract "Silva_119_rep_set97.fna", a representative set of SILVA rRNA references of version119 at 97\% sequence identity.}

\item{taxonomy}{a taxonomic path file mapping to the template file, default to load "Silva_119_rep_set97.fna" matched "taxonomy" stored in the package.}

\item{ksize, iters, cutoff, processors}{parameters used in \href{http://www.mothur.org/wiki/Classify.seqs}{Classify.seqs} by Mothur. \code{ksize}, kmer size which is a search option with the 'Wang' method and by default to 8.  \code{iters}, iterations by default 100 to calculate the bootstrap confidence score for the assigned taxonomy. \code{cutoff}, a bootstrap confidence score for the taxonomy assignment, by default 80, which means a minimum 80\% sequences were assigned by the same taxonomy, a higher value gives a more strict taxonomy assignment. \code{processors}, the number of central processing units you use to run the command, by default to 1.}

\item{dir.out}{a directory where the assigned files were outputted, by default to create \code{assignTax_out} directory and output assigned files under this directory.}
}
\value{
two files under \code{dir.out}, a \code{*.taxonomy} file which contains a taxonomic path for each sequence and a \code{*.tax.summary} file which contains a taxonomic outline indicating the number of sequences that were found at each level (kingdom to species).
a list containing the following components:
exitStatus  an error code ('0' for success) given by the execution of the system Mothur commands, see \code{\link[base]{system}}.
stderr, stdout standard errors and outputs by executing Mothur command 'classify.seqs'.
}
\description{
Assign taxonomic paths to unclassified SSU rRNA sequences, by executing \code{classify.seqs} in \href{http://www.mothur.org/}{Mothur} with the 'Wang' approach.
}
\details{
This function performs 'classify.seqs' by running Mothur in command line mode, hence the executable Mothur on your computer is needed. For unix users, the absolute path of Mothur should be added to the PATH environmental variable and exported. For Windows users, the executable Mothur with extension .exe is required under your disks.
}

