% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridgeEnrichment.R
\name{ridgeEnrichment}
\alias{ridgeEnrichment}
\title{Visualize Enrichment Distributions Using Ridge Plots}
\usage{
ridgeEnrichment(
  input.data,
  gene.set.use,
  assay = NULL,
  group.by = NULL,
  color.by = "group",
  order.by = NULL,
  scale = FALSE,
  facet.by = NULL,
  add.rug = FALSE,
  palette = "inferno"
)
}
\arguments{
\item{input.data}{Output of \code{\link{escape.matrix}} or a single-cell
object previously processed by \code{\link{runEscape}}.}

\item{gene.set.use}{Character. Name of the gene set to display.}

\item{assay}{Character. Name of the assay holding enrichment scores when
\code{input.data} is a single-cell object. Ignored otherwise.}

\item{group.by}{Character. Metadata column plotted on the y-axis. Defaults
to the Seurat/SCE \code{ident} slot when \code{NULL}.}

\item{color.by}{Character. Aesthetic mapped to fill color. Options:
\itemize{
  \item \code{"group"} (default): Uses \code{group.by} for categorical
    coloring.
  \item \emph{gene-set name}: Use the same value as \code{gene.set.use}
    to obtain a numeric gradient.
  \item Any other metadata column present in the data.
}}

\item{order.by}{Character or \code{NULL}. How to arrange the y-axis:
\itemize{
  \item \code{"mean"}: Groups ordered by decreasing group mean.
  \item \code{"group"}: Natural (alphanumeric) sort of group labels.
  \item \code{NULL} (default): Keep original ordering.
}}

\item{scale}{Logical. If \code{TRUE}, scores are centered and scaled
(Z-score) prior to plotting. Default is \code{FALSE}.}

\item{facet.by}{Character or \code{NULL}. Metadata column used to facet
the plot.}

\item{add.rug}{Logical. If \code{TRUE}, draw per-cell tick marks underneath
each ridge. Default is \code{FALSE}.}

\item{palette}{Character. Color palette name from
\code{\link[grDevices]{hcl.pals}}. Default is \code{"inferno"}.}
}
\value{
A [ggplot2] object.
}
\description{
This function allows the user to examine the distribution of
enrichment across groups by generating a ridge plot.
}
\examples{
gs <- list(Bcells = c("MS4A1", "CD79B", "CD79A", "IGH1", "IGH2"),
           Tcells = c("CD3E", "CD3D", "CD3G", "CD7","CD8A"))
           
pbmc <- SeuratObject::pbmc_small |>
  runEscape(gene.sets = gs, min.size = NULL)

ridgeEnrichment(pbmc, assay = "escape",
                gene.set.use = "Tcells",
                group.by = "groups")

}
