% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performPCA.R
\name{performPCA}
\alias{performPCA}
\title{Perform Principal Component Analysis on Enrichment Data}
\usage{
performPCA(
  input.data,
  assay = "escape",
  scale = TRUE,
  n.dim = 10,
  reduction.name = "escape.PCA",
  reduction.key = "escPC_"
)
}
\arguments{
\item{input.data}{Output of \code{\link{escape.matrix}} or a single-cell
object previously processed by \code{\link{runEscape}}.}

\item{assay}{Character. Name of the assay holding enrichment scores when
\code{input.data} is a single-cell object. Default is \code{"escape"}.
Ignored otherwise.}

\item{scale}{Logical. If \code{TRUE}, standardizes each gene-set column
before PCA. Default is \code{TRUE}.}

\item{n.dim}{Integer. The number of principal components to compute and
keep. Default is \code{10}.}

\item{reduction.name}{Character. Name used for the dimensional reduction
slot when writing back to a Seurat/SCE object. Default is
\code{"escape.PCA"}.}

\item{reduction.key}{Character. Key prefix for the dimensional reduction
when writing back to a Seurat/SCE object. Default is \code{"escPC_"}.}
}
\value{
*If* `input.data` is a single-cell object, the same object with a
  new dimensional-reduction slot.  *Otherwise* a list with  
  `PCA`, `eigen_values`, `contribution`, and `rotation`.
}
\description{
This function allows users to calculate the principal components for the
gene set enrichment values. For single-cell data, the PCA will be stored
with the dimensional reductions. If a matrix is used as input, the output
is a list for further plotting. Alternatively, users can use functions for
PCA calculations based on their desired workflow in lieu of using
\code{\link{performPCA}}, but will not be compatible with downstream
\code{\link{pcaEnrichment}} visualization.
}
\examples{
gs <- list(Bcells = c("MS4A1", "CD79B", "CD79A", "IGH1", "IGH2"),
           Tcells = c("CD3E", "CD3D", "CD3G", "CD7","CD8A"))

pbmc <- SeuratObject::pbmc_small |>
  runEscape(gene.sets = gs,
            min.size = NULL)           
                        
pbmc <- performPCA(pbmc, 
                   assay = "escape")

}
