% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maSignal.R
\name{maSignal}
\alias{maSignal}
\title{Generate MA plots with or without annotation using LODR estimates}
\usage{
maSignal(exDat, alphaPoint = 0.8, r_mAdjust = TRUE, replicate = TRUE)
}
\arguments{
\item{exDat}{list, contains input data and stores analysis results}

\item{alphaPoint}{numeric value, for alpha (transparency) for plotted points,
range is 0 - 1}

\item{r_mAdjust}{default is TRUE, if FALSE then the r_m estimate will not
used to offset dashed lines for empirical ratios on figure}

\item{replicate}{default is TRUE, if FALSE then error bars will not be
produced}
}
\description{
Generate MA plots with or without annotation using LODR estimates
}
\examples{

data(SEQC.Example)

exDat <- initDat(datType="array", isNorm=FALSE, 
                 exTable=UHRR.HBRR.arrayDat,
                 filenameRoot="testRun", sample1Name="UHRR",
                 sample2Name="HBRR", erccmix="RatioPair", 
                 erccdilution = 1, spikeVol = 50, 
                 totalRNAmass = 2.5*10^(3), choseFDR=0.01)
                 
exDat <- est_r_m(exDat)
                  
exDat <- dynRangePlot(exDat)

exDat <- geneExprTest(exDat)
# generate MA plot without LODR annotation
exDat <- maSignal(exDat)

exDat$Figures$maPlot
\donttest{
exDat <- estLODR(exDat, kind = "ERCC", prob = 0.9)

# Include LODR annotation
exDat <- annotLODR(exDat)

exDat$Figures$maPlot
}
}
