% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiSeeker-package.R
\docType{data}
\name{seq2gene_result}
\alias{seq2gene_result}
\title{Result of seq2gene}
\format{
A character vector of gene IDs generated by
\code{seq2gene()} from the subset of peaks derived from demo_peak.
}
\value{
vector of gene names
}
\description{
A character vector of gene IDs returned by \code{seq2gene()}, representing
genes associated with a subset of peaks.  
This dataset is used to illustrate peak-to-gene mapping and regulatory
region annotation workflows in \pkg{epiSeeker}.
See data-raw/example_data.R
}
\section{Data structure}{

A character vector of gene identifiers (ENTREZ IDs) representing genes
linked to the example peak set via TSS proximity or flanking-gene search.
}

\section{Provenance}{

The example peak set \code{demo_peak} was constructed by sampling up to
10 peaks per autosome (chr1–chr22) from the ChIP-seq dataset
\code{GSM6418464}.  
Peaks were imported using \code{readPeakFile()}, subset by chromosome,
and combined into a single \code{GRanges} object.

The gene-level associations were then computed directly using:
\preformatted{
seq2gene_result <- seq2gene(
    demo_peak,
    tssRegion = c(-1000, 1000),
    flankDistance = 3000,
    txdb
)
}

The resulting character vector of gene IDs was saved via
\code{data-raw/example_data.R}.
}

