% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTagMatrix.R
\name{plotPeakProf}
\alias{plotPeakProf}
\title{plot peak profile}
\usage{
plotPeakProf(
  tagMatrix,
  xlab = "Genomic Region (5'->3')",
  ylab = "Peak Count Frequency",
  conf = NULL,
  title = "",
  facet = "none",
  free_y = TRUE,
  statistic_method = "mean",
  missingDataAsZero = TRUE,
  ...
)
}
\arguments{
\item{tagMatrix}{output from getTagMatrix().}

\item{xlab}{xlab.}

\item{ylab}{ylab.}

\item{conf}{confidence interval.}

\item{title}{title.}

\item{facet}{one of 'none', 'row' and 'column'.}

\item{free_y}{if TRUE, y will be scaled.}

\item{statistic_method}{method to do statistic. one of "mean", "median", "min", "max", "sum", "std"}

\item{missingDataAsZero}{set missing data as zero or not.}

\item{...}{additional parameters}
}
\value{
ggplot object
}
\description{
plot peak profile
}
\examples{
data(tagMatrix)
plotPeakProf(tagMatrix)
}
\author{
G Yu; Y Yan
}
