% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeBmData.R
\name{makeBmDataFromFiles}
\alias{makeBmDataFromFiles}
\title{make bmData from files}
\usage{
makeBmDataFromFiles(name, sampleNames = NULL, variablesNames = NULL)
}
\arguments{
\item{name}{the name of files or file folder}

\item{sampleNames}{the name for each file}

\item{variablesNames}{the names of the first two columns will be assigned c("chr","pos"),
the names of the following columns will be assigned by variablesNames}
}
\value{
bmData
}
\description{
This function makes bmData object from files. Users can input
the name of a file or a file folder.
}
\details{
bed files and txt files are supported. Bed files can
   only contain no more than two metadata, as it stands for value1/2. Txt files
   should organize the columns as chr, pos, value1, value2(optional).
}
\examples{
demo_bisseq_file <- system.file("extdata", "demo_bisseq.txt", package="epiSeeker")
data <- makeBmDataFromFiles(demo_bisseq_file, 
                            sampleNames = "acinar_methyl", 
                            variablesNames = c("Cov", "Methylation"))
}
