% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/makeBmData.R
\docType{methods}
\name{makeBmDataFromData}
\alias{makeBmDataFromData}
\alias{makeBmDataFromData,CompressedGRangesList-method}
\alias{makeBmDataFromData,GRanges-method}
\alias{makeBmDataFromData,list-method}
\alias{makeBmDataFromData,data.frame-method}
\title{makeBmDataFromData method generics}
\usage{
makeBmDataFromData(data, sampleNames = NULL)

\S4method{makeBmDataFromData}{CompressedGRangesList}(data, sampleNames = NULL)

\S4method{makeBmDataFromData}{GRanges}(data, sampleNames = NULL)

\S4method{makeBmDataFromData}{list}(data, sampleNames = NULL)

\S4method{makeBmDataFromData}{data.frame}(data, sampleNames = NULL)
}
\arguments{
\item{data}{lists object}

\item{sampleNames}{the name of each samples}
}
\value{
bmData
}
\description{
makeBmDataFromData method generics

makeBmDataFromData method for `CompressedGRangesList` objects

makeBmDataFromData method for `GRanges` objects

makeBmDataFromData method for `list` objects

makeBmDataFromData method for \code{data.frame} objects
}
\details{
The objects in `data` must have specific forms. Colunms should be
   features, which should be organized in the order of "chr", "pos", "value1",
   "value2(optional)". chr stands for chromosome. pos stands for position on
   chromosome, also known as coordinates. value1/2 stands for the value on each base.
   The colnames can be any character but must be in the order. Rows stands for each
   observation.

The objects in \code{data} must have specific forms. Colunms should be
   features, which should be organized in the order of "chr", "pos", "value1",
   "value2(optional)". chr stands for chromosome. pos stands for position on
   chromosome, also known as coordinates. value1/2 stands for the value on each base.
   The colnames can be any character but must be in the order. Rows stands for each
   observation.
}
\examples{
demo_bisseq_file <- system.file("extdata", "demo_bisseq.txt", 
                                package="epiSeeker")
demo_bisseq <- read.table(demo_bisseq_file,header = TRUE)
demo_bmdata <- makeBmDataFromData(data = list(acinar_methyl = demo_bisseq), 
                                  sampleNames = "acinar_methyl")
}
