% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagMatrix.R
\name{getTagMatrix}
\alias{getTagMatrix}
\title{getTagMatrix}
\usage{
getTagMatrix(
  peak,
  upstream = 0,
  downstream = 0,
  windows = NULL,
  type = NULL,
  by = NULL,
  TxDb = NULL,
  weightCol = NULL,
  nbin = NULL,
  verbose = TRUE,
  ignore_strand = FALSE
)
}
\arguments{
\item{peak}{(1) a peak file or GRanges object. (2) a list of peak file or GRanges object.}

\item{upstream}{upstream extension. One of actual number or rel() object.}

\item{downstream}{downstream extension. One of actual number or rel() object.}

\item{windows}{a collection of region}

\item{type}{one of "start_site", "end_site", "body"}

\item{by}{one of 'gene', 'transcript', 'exon', 'intron', '3UTR' , '5UTR', or specified by users}

\item{TxDb}{TxDb or self-made granges object, served as txdb}

\item{weightCol}{column name of weight, default is NULL.This column acts as a weight vaule. 
Details see \url{https://github.com/YuLab-SMU/ChIPseeker/issues/15}}

\item{nbin}{the amount of nbines. Calculate the tagMatrix by binning method.
Idea is derived from the function of deeptools(https://deeptools.readthedocs.io/en/develop/content/tools/computeMatrix.html)}

\item{verbose}{print message or not}

\item{ignore_strand}{ignore the strand information or not}
}
\value{
tagMatrix
}
\description{
getTagMatrix
}
\details{
getTagMatrix() function can produce the matrix for visualization. 
Matrix represents the peak count in a windows and there are two ways to specify the 'windows': 

(1) use \code{\link{getPromoters}} and \code{\link{getBioRegion}} to get 'windows' and 
put it into windows parameter in getTagMatrix(). 

(2) use getTagMatrix() to call getPromoters()/getBioRegion(). 
In this way users do not need to input 'windows' parameter but need to input 'TxDb' parameter. 
'TxDb' can accept a set of packages contained annotation of regions of 
different genomes(e.g. TxDb.Hsapiens.UCSC.hg38.knownGene). 
Users can get the regions of interest through specific functions. 
These specific functions are built in getPromoters()/getBioRegion(). 

However, many regions can not be gain through txdb(e.g. insulator and enhancer regions),
Users can provide these regions in the form of granges object. 
These self-made granges object will be passed to 'TxDb' and they will
be passed to makeBioRegionFromGranges() to produce the 'windows'.

In a word, 'TxDb' parameter getTagMatrix() is a reference information. 
Users can pass txdb object or self-made granges into it.
}
\examples{
if (interactive()) {
  require(TxDb.Hsapiens.UCSC.hg38.knownGene)
  txdb <- TxDb.Hsapiens.UCSC.hg38.knownGene
  data(demo_peak)
  tagMatrix <- getTagMatrix(demo_peak, type = "start_site", by = "gene", 
                            upstream = 500, downstream = 500,
                            TxDb = txdb, weightCol = "V7")
}
}
\author{
G Yu
}
