% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagMatrix.R
\name{getPromoters}
\alias{getPromoters}
\title{Get promoter region in GRanges format}
\usage{
getPromoters(TxDb = NULL, upstream = 1000, downstream = 1000, by = "gene")
}
\arguments{
\item{TxDb}{TxDb object}

\item{upstream}{upstream extension. One of actual number or rel() object.}

\item{downstream}{downstream extension. One of actual number or rel() object.}

\item{by}{one of 'gene', 'transcript'.}
}
\value{
GRanges object
}
\description{
Get promoter region in GRanges format
}
\examples{
require(TxDb.Hsapiens.UCSC.hg38.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg38.knownGene
promoters <- getPromoters(TxDb = txdb, upstream = 1000, downstream = 1000)
}
\author{
Guangchuang Yu
}
