% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/pairwise_termsim.R
\name{pairwise_termsim}
\alias{pairwise_termsim}
\alias{pairwise_termsim,enrichResult-method}
\alias{pairwise_termsim,gseaResult-method}
\alias{pairwise_termsim,compareClusterResult-method}
\alias{pairwise_termsim.enrichResult}
\alias{pairwise_termsim.compareClusterResult}
\title{pairwise_termsim}
\usage{
pairwise_termsim(x, method = "JC", semData = NULL, showCategory = NULL)

\S4method{pairwise_termsim}{enrichResult}(x, method = "JC", semData = NULL, showCategory = NULL)

\S4method{pairwise_termsim}{gseaResult}(x, method = "JC", semData = NULL, showCategory = NULL)

\S4method{pairwise_termsim}{compareClusterResult}(x, method = "JC", semData = NULL, showCategory = NULL)

pairwise_termsim.enrichResult(
  x,
  method = "JC",
  semData = NULL,
  showCategory = NULL
)

pairwise_termsim.compareClusterResult(
  x,
  method = "JC",
  semData = NULL,
  showCategory = NULL
)
}
\arguments{
\item{x}{enrichment result.}

\item{method}{method of calculating the similarity between nodes,
one of "Resnik", "Lin", "Rel", "Jiang", "Wang", and
"JC" (Jaccard similarity coefficient) methods.}

\item{semData}{`GOSemSimDATA` object, can be obtained through
`GOSemSim::godata`.}

\item{showCategory}{number of enriched terms to be calculated. The default value is the number of enriched terms, or 200 if the number of enriched terms exceeds 200.}
}
\description{
Get the similarity matrix
}
\details{
This function adds a similarity matrix to the termsim slot of the enrichment result.
Users can use the `method` parameter to select the method of calculating the similarity.
The Jaccard correlation coefficient (JC) is used by default, and it applies to all situations.
When users want to calculate the correlation between GO terms or DO terms, they can also choose
"Resnik", "Lin", "Rel" or "Jiang" (they are semantic similarity calculation methods from the 'GOSemSim' package),
and at this time, the user needs to provide the `semData` parameter, which can be obtained through
\code{\link[GOSemSim]{godata}}.
}
\examples{
\dontrun{
    library(clusterProfiler)
    library(org.Hs.eg.db)
    library(enrichplot)
    library(GOSemSim)
    library(DOSE)
    data(geneList)
    gene <- names(geneList)[abs(geneList) > 2]
    ego <- enrichGO(gene  = gene,
        universe      = names(geneList),
        OrgDb         = org.Hs.eg.db,
        ont           = "BP",
        pAdjustMethod = "BH",
        pvalueCutoff  = 0.01,
        qvalueCutoff  = 0.05,
        readable      = TRUE)
    d <- godata('org.Hs.eg.db', ont="BP")
    ego2 <- pairwise_termsim(ego, method="Wang", semData = d)
    emapplot(ego2)
    emapplot_cluster(ego2)
   }
}
