% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/gseaplot.R
\name{gseaplot}
\alias{gseaplot}
\alias{gseaplot,gseaResult-method}
\alias{gseaplot.gseaResult}
\title{gseaplot}
\usage{
gseaplot(x, geneSetID, by = "all", title = "", ...)

\S4method{gseaplot}{gseaResult}(
  x,
  geneSetID,
  by = "all",
  title = "",
  color = "black",
  color.line = "green",
  color.vline = "#FA5860",
  ...
)

gseaplot.gseaResult(
  x,
  geneSetID,
  by = "all",
  title = "",
  color = "black",
  color.line = "green",
  color.vline = "#FA5860",
  ...
)
}
\arguments{
\item{x}{gseaResult object}

\item{geneSetID}{geneSet ID}

\item{by}{one of "runningScore" or "position"}

\item{title}{plot title}

\item{...}{additional parameters}

\item{color}{color of line segments}

\item{color.line}{color of running enrichment score line}

\item{color.vline}{color of vertical line indicating the
maximum/minimal running enrichment score}
}
\value{
ggplot2 object

ggplot2 object
}
\description{
Visualize GSEA analysis results
}
\details{
Plotting function for gseaResult
}
\examples{
\donttest{
library(DOSE)
data(geneList)
x <- gseDO(geneList)
gseaplot(x, geneSetID=1)
}
}
\author{
Guangchuang Yu
}
