% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/emapplot.R
\name{emapplot}
\alias{emapplot}
\alias{emapplot,enrichResult-method}
\alias{emapplot,gseaResult-method}
\alias{emapplot,compareClusterResult-method}
\alias{emapplot_internal}
\title{emapplot}
\usage{
emapplot(x, ...)

\S4method{emapplot}{enrichResult}(x, showCategory = 30, ...)

\S4method{emapplot}{gseaResult}(x, showCategory = 30, ...)

\S4method{emapplot}{compareClusterResult}(x, showCategory = 30, ...)

emapplot_internal(
  x,
  layout = igraph::layout_with_kk,
  showCategory = 30,
  color = "p.adjust",
  size_category = 1,
  min_edge = 0.2,
  color_edge = "grey",
  size_edge = 0.5,
  node_label = "category",
  node_label_size = 5,
  pie = "equal",
  label_format = 30,
  clusterFunction = stats::kmeans,
  nWords = 4,
  nCluster = NULL
)
}
\arguments{
\item{x}{Enrichment result.}

\item{...}{Additional parameters}

\item{showCategory}{number of categories to display or a vector of terms.}

\item{layout}{igraph layout}

\item{color}{Variable used to color enriched terms, e.g. 'pvalue',
'p.adjust' or 'qvalue'.}

\item{size_category}{relative size of the categories}

\item{min_edge}{The minimum similarity threshold for whether
two nodes are connected, should be between 0 and 1, default value is 0.2.}

\item{color_edge}{color of the network edge}

\item{size_edge}{relative size of edge width}

\item{node_label}{Select which labels to display,
one of 'category', 'group', 'all' and 'none'.}

\item{node_label_size}{size of node label, default is 5.}

\item{pie}{one of 'equal' or 'Count' to set the slice ratio of the pies}

\item{label_format}{a numeric value sets wrap length, alternatively a custom function to format axis labels.}

\item{clusterFunction}{function of Clustering method, such as `stats::kmeans` (the default),
`cluster::clara`, `cluster::fanny` or `cluster::pam`.}

\item{nWords}{Numeric, the number of words in the cluster tags, the default value is 4.}

\item{nCluster}{Numeric, the number of clusters,
the default value is square root of the number of nodes.}
}
\value{
ggplot object
}
\description{
Enrichment Map for enrichment result of
over-representation test or gene set enrichment analysis
}
\details{
This function visualizes gene sets as a network (i.e. enrichment map).
Mutually overlapping gene sets tend to cluster together, making it
easier for interpretation. When the similarity between terms meets
a certain threshold (default is 0.2, adjusted by parameter `min_edge`),
there will be edges between terms. The stronger the similarity,
the shorter and thicker the edges. The similarity between terms is
obtained by the function `pairwise_termsim`. Details of the similarity
calculation can be found in its documentation: \link{pairwise_termsim}.
}
\examples{
\dontrun{
    library(DOSE)
    data(geneList)
    de <- names(geneList)[1:100]
    x <- enrichDO(de)
    x2 <- pairwise_termsim(x)
    emapplot(x2)
    # use `layout` to change the layout of map
    emapplot(x2, layout = "star")
    # use `showCategory` to  select the displayed terms. It can be a number of a vector of terms.
    emapplot(x2, showCategory = 10)
    categories <- c("pre-malignant neoplasm", "intestinal disease",
                   "breast ductal carcinoma")
    emapplot(x2, showCategory = categories)

    # It can also graph compareClusterResult
    library(clusterProfiler)
    library(DOSE)
    library(org.Hs.eg.db)
    data(gcSample)
    xx <- compareCluster(gcSample, fun="enrichGO", OrgDb="org.Hs.eg.db")
    xx2 <- pairwise_termsim(xx)
    emapplot(xx2)
}
}
\author{
Guangchuang Yu
}
