% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnetplot.R
\name{cnetplot.enrichResult}
\alias{cnetplot.enrichResult}
\alias{cnetplot.gseaResult}
\alias{cnetplot.compareClusterResult}
\title{Category-Gene-Network Plot}
\usage{
\method{cnetplot}{enrichResult}(
  x,
  layout = igraph::layout_with_kk,
  showCategory = 5,
  color_category = "#E5C494",
  size_category = 1,
  color_item = "#B3B3B3",
  size_item = 1,
  color_edge = "grey",
  size_edge = 0.5,
  categorySizeBy = ~itemNum,
  node_label = "all",
  foldChange = NULL,
  fc_threshold = NULL,
  hilight = "none",
  hilight_alpha = 0.3,
  ...
)

\method{cnetplot}{gseaResult}(
  x,
  layout = igraph::layout_with_kk,
  showCategory = 5,
  color_category = "#E5C494",
  size_category = 1,
  color_item = "#B3B3B3",
  size_item = 1,
  color_edge = "grey",
  size_edge = 0.5,
  categorySizeBy = ~itemNum,
  node_label = "all",
  foldChange = NULL,
  fc_threshold = NULL,
  hilight = "none",
  hilight_alpha = 0.3,
  ...
)

\method{cnetplot}{compareClusterResult}(
  x,
  layout = igraph::layout_with_kk,
  showCategory = 5,
  color_category = "#E5C494",
  size_category = 1,
  color_item = "#B3B3B3",
  size_item = 1,
  color_edge = "grey",
  size_edge = 0.5,
  categorySizeBy = NULL,
  node_label = "all",
  foldChange = NULL,
  fc_threshold = NULL,
  hilight = "none",
  hilight_alpha = 0.3,
  pie = "equal",
  ...
)
}
\arguments{
\item{x}{input object}

\item{layout}{network layout}

\item{showCategory}{number of categories to display or a vector of terms.}

\item{color_category}{color of category nodes}

\item{size_category}{relative size of the category nodes}

\item{color_item}{color of item nodes}

\item{size_item}{relative size of the item nodes (e.g., genes)}

\item{color_edge}{color of edge}

\item{size_edge}{relative size of edge}

\item{categorySizeBy}{method of category size, one of "itemNum" (default), "pvalue", "p.adjust", "qvalue" or a numeric vector}

\item{node_label}{one of 'all', 'none', 'category', 'item', 'exclusive' or 'share'.
'exclusive' labels genes that uniquely belong to categories; 'share' labels genes that are shared between categories.}

\item{foldChange}{numeric values to color the item (e.g., fold change of gene expression values)}

\item{fc_threshold}{threshold for filtering genes by absolute fold change (e.g., fc_threshold = 1 keeps only genes with |foldChange| > 1).}

\item{hilight}{selected categories to be highlighted}

\item{hilight_alpha}{transparency value for non-highlighted items}

\item{...}{additional parameters}

\item{pie}{one of 'equal' or 'Count' to set the slice ratio of the pies}
}
\description{
Category-gene-network plot
}
\seealso{
[cnetplot][ggtangle::cnetplot]
}
