% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsEmapInternal.R
\encoding{UTF-8}
\name{validateCreateEnrichMapAsIgraphArg}
\alias{validateCreateEnrichMapAsIgraphArg}
\title{Validate arguments passed to createEnrichMapAsIgraph() function}
\usage{
validateCreateEnrichMapAsIgraphArg(
  gostObject,
  query,
  source,
  termIDs,
  removeRoot,
  showCategory,
  similarityCutOff
)
}
\arguments{
\item{gostObject}{a \code{list} created by \code{gprofiler2} that contains
the results from an enrichment analysis.}

\item{query}{a \code{character} string representing the name of the query 
that is going to be used to generate the graph. The query must exist in the 
\code{gostObject} object.}

\item{source}{a \code{character} string representing the selected source 
that will be used to generate the network. To hand-pick the terms to be 
used, "TERM_ID" should be used and the list of selected term IDs should
be passed through the \code{termIDs} parameter. The possible sources are 
"GO:BP" for Gene Ontology Biological Process, "GO:CC" for Gene Ontology  
Cellular Component, "GO:MF" for Gene Ontology Molecular Function, 
"KEGG" for Kegg, "REAC" for Reactome, "TF" for TRANSFAC, "MIRNA" for 
miRTarBase, "CORUM" for CORUM database, "HP" for Human phenotype ontology
and "WP" for WikiPathways.}

\item{termIDs}{a \code{vector} of \code{character} strings that contains 
the term IDs retained for the creation of the network. This parameter is 
only used when \code{source} is set to "TERM_ID".}

\item{removeRoot}{a \code{logical} that specified if the root terms of 
the selected source should be removed (when present).}

\item{showCategory}{a positive \code{integer} or a \code{vector} of 
\code{characters} representing terms.  If a \code{integer}, the first 
\code{n} terms will be displayed. If \code{vector} of terms, 
the selected terms will be displayed.}

\item{similarityCutOff}{a positive \code{numeric} between 0 and 1 indicating 
the minimum level of similarity between two terms to have an edge linking 
the terms.}
}
\value{
\code{TRUE} when all arguments are valid
}
\description{
Validate the arguments passed to createEnrichMapAsIgraph() 
function.First, the object containing the enrichment results must 
correspond to a 
object created by \code{gprofiler2} software. Second, the selected 
source must at least have one enriched term in the results. Then, if the
source is 'TERM_ID', the listed terms must be present in the enrichment
results.
}
\examples{

## Load the result of an enrichment analysis done with gprofiler2
data(demoGOST)

## Check that all arguments are valid
enrichViewNet:::validateCreateEnrichMapAsIgraphArg(
    gostObject=demoGOST, query="query_1", source="GO:BP", termIDs=NULL, 
    removeRoot=FALSE, showCategory=20, similarityCutOff=0.5)

}
\author{
Astrid Deschênes
}
\keyword{internal}
