% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\encoding{UTF-8}
\name{createNetwork}
\alias{createNetwork}
\title{Using functional enrichment results from gprofiler2 to create a 
Cytoscape network}
\usage{
createNetwork(
  gostObject,
  source = c("TERM_ID", "GO:MF", "GO:CC", "GO:BP", "KEGG", "REAC", "TF", "MIRNA", "HPA",
    "CORUM", "HP", "WP"),
  termIDs = NULL,
  removeRoot = TRUE,
  query = NULL,
  title = "gprofiler network",
  collection = "enrichment results",
  fileName = "gprofilerNetwork.cx"
)
}
\arguments{
\item{gostObject}{a \code{list} created by gprofiler2 that contains
the results from an enrichment analysis.}

\item{source}{a \code{character} string representing the selected source 
that will be used to generate the network. To hand-pick the terms to be 
used, "TERM_ID" should be used and the list of selected term IDs should
be passed through the \code{termIDs} parameter. The possible sources are 
"GO:BP" for Gene Ontology Biological Process, "GO:CC" for Gene Ontology  
Cellular Component, "GO:MF" for Gene Ontology Molecular Function, 
"KEGG" for Kegg, "REAC" for Reactome, "TF" for TRANSFAC, "MIRNA" for 
miRTarBase, "CORUM" for CORUM database, "HP" for Human phenotype ontology
and "WP" for WikiPathways.  Default: "TERM_ID".}

\item{termIDs}{a \code{vector} of \code{character} strings that contains the
term IDS retained for the creation of the network. Default: \code{NULL}.}

\item{removeRoot}{a \code{logical} that specified if the root terms of 
the selected source should be removed (when present). Default: \code{TRUE}.}

\item{query}{a \code{character} string that specified the retained query to 
generate the network. When \code{NULL}, the query present in the result 
is retained; \code{NULL} cannot be used when more than one query is present. 
Default: \code{NULL}.}

\item{title}{a \code{character} string representing the name assigned to 
the network. Default: "gprofiler network".}

\item{collection}{a \code{character} string representing the collection 
name assigned to the network. Default: "enrichment results".}

\item{fileName}{a \code{character} string representing the name of the
CX JSON file that is created when Cytoscape is not running. The name 
must have a '.cx' extension.
Default: "gprofilerNetwork_01.cx".}
}
\value{
\code{TRUE}
}
\description{
User selected enrichment terms are used to create a Cytoscape 
network where the selected terms and the genes that where part of the 
enrichment analysis are all represented as nodes. Edges are linking the 
genes to their terms. The selection of the term can by specifying  the 
source of the terms (GO:MF, REAC, TF, etc.) or by listing the selected 
term IDs. The network is only generated when there is at least on 
significant term to graph. When the enrichment analysis contains more than 
one query, only one query can be selected to generate the network.
}
\examples{

## Loading dataset containing result from an enrichment analysis done with
## gprofiler2
data(parentalNapaVsDMSOEnrichment)

## Some of the enrichment results present in the dataset
head(parentalNapaVsDMSOEnrichment$result)

## Create network for Gene Ontology - Molecular Function related results
## in Cytoscape (when the application is opened)
## Otherwise, create a CX file in the temporary directory
## The file can be opened in Cytoscape
createNetwork(gostObject=parentalNapaVsDMSOEnrichment, source="KEGG", 
    removeRoot=FALSE, title="KEGG Graph", 
    fileName=file.path(tempdir(), "KEGG_demo.cx"))


}
\author{
Astrid Deschênes
}
