% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsEmapInternal.R
\encoding{UTF-8}
\name{createMultiEmap}
\alias{createMultiEmap}
\title{Create a basic enrichment map}
\usage{
createMultiEmap(
  gostResultsList,
  queryList,
  showCategory,
  categoryLabel,
  categoryNode,
  line,
  ...
)
}
\arguments{
\item{gostResultsList}{a \code{list} of \code{data.frame} containing 
the enrichment results to be plot with different group identification.}

\item{queryList}{a \code{list} of \code{character} string 
representing the name of query retained for each enrichment results present 
in the \code{gostResultsList} parameter. The query should be present in its 
associated enrichment results.}

\item{showCategory}{a positive \code{integer} or a \code{vector} of 
\code{characters} representing terms.  If a \code{integer}, the first 
\code{n} terms will be displayed. If \code{vector} of terms, 
the selected terms will be displayed.}

\item{categoryLabel}{a positive \code{numeric} representing the amount by 
which plotting category nodes label size should be scaled relative 
to the default (1).}

\item{categoryNode}{a positive \code{numeric} representing the amount by 
which plotting category nodes should be scaled relative to the default (1).}

\item{line}{a non-negative \code{numeric} representing the scale of line 
width.}

\item{...}{additional arguments that will be pass to the 
\code{\link[enrichplot]{emapplot}} function.}
}
\value{
a \code{ggplot} object representing the enrichment map with 
different colors for each group of enrichment results.
}
\description{
The function creates a basic enrichment map using functional 
enrichment results.
}
\examples{

## Load the result of an enrichment analysis done with gprofiler2
data(parentalNapaVsDMSOEnrichment)

## Only retain the results section
gostResults <- as.data.frame(parentalNapaVsDMSOEnrichment$result)

## Limit the results subsection of REACTOME and KEGG
gostResultsREAC <- gostResults[which(gostResults$source == "REAC"),]
gostResultsREAC <- gostResultsREAC[1:13, ]
gostResultsKEGG <- gostResults[which(gostResults$source == "KEGG"),]

## Extract meta data information
queryList <- list("parental - REACTOME", "parental - KEGG")

## Create basic enrichment map using Wikipathways terms
enrichViewNet:::createMultiEmap(gostResultsList=list(gostResultsREAC, 
    gostResultsKEGG), queryList=queryList, showCategory=30L, 
    categoryLabel=1, categoryNode=1, line=1.4)
    
}
\author{
Astrid Deschênes
}
\keyword{internal}
