% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveAlignments.R
\name{saveAlignments}
\alias{saveAlignments}
\title{output alignments}
\usage{
saveAlignments(
  al,
  output_folder = tempdir(),
  motifConsensus = NULL,
  format = c("txt", "html")
)
}
\arguments{
\item{al}{output of \link{alignment}.}

\item{output_folder}{output folder.}

\item{motifConsensus}{Transcription factor binding consensus.}

\item{format}{The format of output files.
Available formats are 'txt' and 'html'. Default is 'txt'.}
}
\value{
The I/O status.
}
\description{
Save enhancer homologs to file in phylip format.
}
\examples{
al <- readRDS(system.file("extdata", "al.rds",
               package="enhancerHomologSearch"))
tmpfolder <- tempdir()
library(MotifDb)
motifs <- query(MotifDb, "JASPAR_CORE")
consensus <- sapply(motifs, consensusString)
consensus <- DNAStringSet(gsub("\\\\?", "N", consensus))
saveAlignments(al, output_folder=tmpfolder, motifConsensus=consensus)
}
