% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easylift.R
\name{easylift}
\alias{easylift}
\title{Lift genomic coordinates from one genome assembly to another.}
\usage{
easylift(x, to, chain, bfc)
}
\arguments{
\item{x}{A GRanges object with genomic coordinates in the original assembly.}

\item{to}{The target genome assembly (e.g., "hg38").}

\item{chain}{The path to the chain file containing the liftover mapping.
Can be provided in gzipped or non-gzipped format. If omitted, the function
will look in the default BiocFileCache for a properly named chain file.}

\item{bfc}{A BiocFileCache object (optional), if not provided (most typically)
the default location will be used.}
}
\value{
A GRanges object with lifted genomic coordinates.
}
\description{
This function takes a GRanges object with genomic coordinates in one genome
assembly and lifts them to target genome assembly using a chain file.
}
\examples{
# Lift over the coordinates of the first 10 genes in the hg19 assembly
# to the hg38 assembly
library(easylift)
gr <- GRanges(
  seqname = Rle(c("chr1", "chr2"), c(100000, 100000)),
  ranges = IRanges(start = 1, end = 200000)
)
# Here, "hg19" is the source genome
genome(gr) <- "hg19"

# Here, we use the `system.file()` function because the chain file is in the
# package (however if you need to point to any other file on your machine,
# just do 'chain <- "path/to/your/hg19ToHg38.over.chain.gz"'):
chain <- system.file("extdata", "hg19ToHg38.over.chain.gz", package = "easylift")

# Here, "hg38" is the target genome
easylift(gr, "hg38", chain)

\donttest{
# To use `BiocFileCache` for the chain file, add it to the cache as follows:
chain_file <- "/path/to/your/hg19ToHg38.over.chain.gz"
bfc <- BiocFileCache()

# Add chain file to cache if already not available
if (nrow(bfcquery(bfc, basename(chain_file))) == 0)
   bfcadd(bfc, chain_file)

# Then, use it in `easylift` like this:

easylift(gr, "hg38")
# or
gr |> easylift("hg38")
}
}
\seealso{
\code{\link[rtracklayer]{liftOver}} function from the \code{rtracklayer} package,
which is the basis for \code{easylift}.
}
