% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_with_rmtlr.R
\name{predict_with_rmtlr}
\alias{predict_with_rmtlr}
\title{Predict single-view immune response}
\usage{
predict_with_rmtlr(
  view_name,
  view_info,
  view_data,
  opt_model_cancer_view_spec,
  opt_xtrain_stats_cancer_view_spec,
  verbose = TRUE
)
}
\arguments{
\item{view_name}{character string containing the name of the
input view.}

\item{view_info}{character string informing about the family of
the input data.}

\item{view_data}{list containing the data for each input view.}

\item{opt_model_cancer_view_spec}{cancer-view-specific model
feature parameters learned during training. These are available
from easierData package through \code{easierData::get_opt_models()}.}

\item{opt_xtrain_stats_cancer_view_spec}{cancer-view-specific
features mean and standard deviation of the training set. These
are available from easierData package through
\code{easierData::get_opt_xtrain_stats()}.}

\item{verbose}{logical flag indicating whether to display
messages about the process.}
}
\value{
A list of predictions, one for each task, in a matrix
format (rows = samples; columns = [runs).
}
\description{
Obtains predictions of immune response for individual
quantitative descriptors by using a cancer-specific
model learned with Regularized Multi-Task Linear
Regression algorithm (RMTLR).
}
\examples{
\donttest{
# using a SummarizedExperiment object
library(SummarizedExperiment)
# Using example exemplary dataset (Mariathasan et al., Nature, 2018)
# from easierData. Original processed data is available from
# IMvigor210CoreBiologies package.
library("easierData")

dataset_mariathasan <- easierData::get_Mariathasan2018_PDL1_treatment()
RNA_tpm <- assays(dataset_mariathasan)[["tpm"]]
cancer_type <- metadata(dataset_mariathasan)[["cancertype"]]

# Select a subset of patients to reduce vignette building time.
pat_subset <- c(
  "SAM76a431ba6ce1", "SAMd3bd67996035", "SAMd3601288319e",
  "SAMba1a34b5a060", "SAM18a4dabbc557"
)
RNA_tpm <- RNA_tpm[, colnames(RNA_tpm) \%in\% pat_subset]

# Computation of TF activity (Garcia-Alonso et al., Genome Res, 2019)
tf_activities <- compute_TF_activity(
  RNA_tpm = RNA_tpm
)

view_name <- "tfs"
view_info <- c(tfs = "gaussian")
view_data <- list(tfs = as.data.frame(tf_activities))

# Retrieve internal data
opt_models <- suppressMessages(easierData::get_opt_models())
opt_xtrain_stats <- suppressMessages(easierData::get_opt_xtrain_stats())

opt_model_cancer_view_spec <- lapply(view_name, function(X) {
  return(opt_models[[cancer_type]][[X]])
})
names(opt_model_cancer_view_spec) <- view_name
opt_xtrain_stats_cancer_view_spec <- lapply(view_name, function(X) {
  return(opt_xtrain_stats[[cancer_type]][[X]])
})
names(opt_xtrain_stats_cancer_view_spec) <- view_name

# Predict using rmtlr
prediction_view <- predict_with_rmtlr(
  view_name = view_name,
  view_info = view_info,
  view_data = view_data,
  opt_model_cancer_view_spec = opt_model_cancer_view_spec,
  opt_xtrain_stats_cancer_view_spec = opt_xtrain_stats_cancer_view_spec
)
}
}
