% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_pathway_activity.R
\name{compute_pathway_activity}
\alias{compute_pathway_activity}
\title{Compute pathway activity from gene expression using PROGENy}
\usage{
compute_pathway_activity(
  RNA_counts = NULL,
  remove_sig_genes_immune_response = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{RNA_counts}{data.frame containing raw counts values with HGNC
gene symbols as row names and samples identifiers as column names.}

\item{remove_sig_genes_immune_response}{logical value indicating
whether to remove signature genes involved in the derivation of
hallmarks of immune response. This list is available from easierData
package through \code{easierData::get_cor_scores_genes()}.}

\item{verbose}{logical value indicating whether to display messages
about the number of pathway signature genes found in the gene
expression data provided.}
}
\value{
A matrix of activity scores with samples in rows and pathways
in columns.
}
\description{
Infers pathway activity from counts bulk gene expression
using PROGENy method from Holland et al., BBAGRM, 2019 and
Schubert et al., Nat Commun, 2018.
}
\examples{
# using a SummarizedExperiment object
library(SummarizedExperiment)
# Using example exemplary dataset (Mariathasan et al., Nature, 2018)
# from easierData. Original processed data is available from
# IMvigor210CoreBiologies package.
library("easierData")

dataset_mariathasan <- easierData::get_Mariathasan2018_PDL1_treatment()
RNA_counts <- assays(dataset_mariathasan)[["counts"]]

# Select a subset of patients to reduce vignette building time.
pat_subset <- c(
  "SAM76a431ba6ce1", "SAMd3bd67996035", "SAMd3601288319e",
  "SAMba1a34b5a060", "SAM18a4dabbc557"
)
RNA_counts <- RNA_counts[, colnames(RNA_counts) \%in\% pat_subset]

# Computation of pathway activity
# (Holland et al., BBAGRM, 2019; Schubert et al., Nat Commun, 2018)
pathway_activity <- compute_pathway_activity(
  RNA_counts = RNA_counts,
  remove_sig_genes_immune_response = TRUE
)
}
\references{
Schubert M, Klinger B, Klunemann M, Sieber A, Uhlitz F, Sauer S,
Garnett MJ, Bluthgen N, Saez-Rodriguez J. “Perturbation-response genes reveal
signaling footprints in cancer gene expression.” Nature Communications:
10.1038/s41467-017-02391-6

Holland CH, Szalai B, Saez-Rodriguez J. "Transfer of regulatory
knowledge from human to mouse for functional genomics analysis." Biochimica et
Biophysica Acta (BBA) - Gene Regulatory Mechanisms. 2019.
DOI: 10.1016/j.bbagrm.2019.194431.
}
