% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_CYT.R
\name{compute_CYT}
\alias{compute_CYT}
\title{Compute cytolytic activity (CYT) score}
\usage{
compute_CYT(matches, RNA_tpm)
}
\arguments{
\item{matches}{numeric vector indicating the index of signature
genes in \code{RNA_tpm}.}

\item{RNA_tpm}{data.frame containing TPM values with HGNC symbols
in rows and samples in columns.}
}
\value{
A numeric matrix with samples in rows and CTY score
in a column.
}
\description{
Calculates the CYT score using the geometric mean of its
signature genes, as defined in Rooney et al., Cell, 2015.
}
\references{
Rooney, M.S., Shukla, S.A., Wu, C.J., Getz, G.,
and Hacohen, N. (2015). Molecular and genetic properties
of tumors associated with local immune cytolytic activity.
Cell 160, 48–61. https://doi.org/10.1016/j.cell.2014.12.033.
}
