% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeLogCPM.R
\name{computeNormCounts}
\alias{computeNormCounts}
\title{Compute normalized counts}
\usage{
computeNormCounts(sce)
}
\arguments{
\item{sce}{\code{SingleCellExperiment} with counts stored as \code{counts(sce)}}
}
\value{
matrix of CPM values
}
\description{
Compute normalized counts as counts per million
}
\details{
This function gives same result as \code{edgeR::cpm(counts(sce), log=FALSE)}
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

normcounts(example_sce) <- computeNormCounts(example_sce)
}
\seealso{
also \code{edgeR::cpm()}
}
