% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_fxns.R
\name{test_differential_linkages}
\alias{test_differential_linkages}
\title{Statistical test for differential linkages across multiple domino results}
\usage{
test_differential_linkages(
  linkage_summary,
  cluster,
  group.by,
  linkage = "rec_lig",
  subject_names = NULL,
  test_name = "fishers.exact"
)
}
\arguments{
\item{linkage_summary}{a \code{\link[=linkage_summary]{linkage_summary()}} object}

\item{cluster}{the name of the cell cluster being compared across multiple domino results}

\item{group.by}{the name of the column in \code{linkage_summary@subject_meta} by which to group subjects for counting.}

\item{linkage}{a stored linkage from the domino object. Can compare any of 'tfs', 'rec', 'incoming_lig', 'tfs_rec', or 'rec_lig'}

\item{subject_names}{a vector of subject_names from the linkage_summary to be compared. If NULL, all subject_names in the linkage summary are included in counting.}

\item{test_name}{the statistical test used for comparison.
\itemize{
\item{'fishers.exact'} : Fisher's exact test for the dependence of the proportion of subjects with an active linkage in the cluster on which group the subject belongs to in the group.by variable. Provides an odds ratio, p-value, and a Benjamini-Hochberg FDR-adjusted p-value (p.adj) for each linkage tested.
}}
}
\value{
A data frame of results from the test of the differential linkages. Rows correspond to each linkage tested. Columns correspond to:
\itemize{
\item{'cluster'} : the name of the cell cluster being compared
\item{'linkage'} : the type of linkage being compared
\item{'group.by'} : the grouping variable
\item{'test_name'} : the test used for comparison
\item{'feature'} : individual linkages compared
\item{'test statistics'} : test statistics provided are based on test method. 'fishers.exact' provides a odds ratio, p-value, and fdr-adjusted p-value.
\item{'total_count'} : total number of subjects where the linkage is active
\item{'X_count'} : number of subjects in each category of group.by (X) where the linkage is active
\item{'total_n'} : number of total subjects compared
\item{'X_n'} : total number of subjects in each category of group.by (X)
}
}
\description{
Statistical test for differential linkages across multiple domino results
}
\examples{
tiny_differential_linkage_c1 <- test_differential_linkages(
  linkage_summary = mock_linkage_summary(), cluster = "C1", group.by = "group",
  linkage = "rec", test_name = "fishers.exact"
)

}
