% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fxns.R
\name{signaling_heatmap}
\alias{signaling_heatmap}
\title{Create a network heatmap}
\usage{
signaling_heatmap(
  dom,
  clusts = NULL,
  min_thresh = -Inf,
  max_thresh = Inf,
  scale = "none",
  normalize = "none",
  ...
)
}
\arguments{
\item{dom}{domino object with network built (\code{\link[=build_domino]{build_domino()}})}

\item{clusts}{vector of clusters to be included. If NULL then all clusters are used.}

\item{min_thresh}{minimum signaling threshold for plotting. Defaults to -Inf for no threshold.}

\item{max_thresh}{maximum signaling threshold for plotting. Defaults to Inf for no threshold.}

\item{scale}{how to scale the values (after thresholding). Options are 'none', 'sqrt' for square root, or 'log' for log10.}

\item{normalize}{options to normalize the matrix. Normalization is done after thresholding and scaling. Accepted inputs are 'none' for no normalization, 'rec_norm' to normalize to the maximum value with each receptor cluster, or 'lig_norm' to normalize to the maximum value within each ligand cluster}

\item{...}{other parameters to pass to  \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}}}
}
\value{
A heatmap rendered to the active graphics device
}
\description{
Creates a heatmap of the signaling network. Alternatively, the network
matrix can be accessed directly in the signaling slot of a domino object using
the \code{\link[=dom_signaling]{dom_signaling()}} function.
}
\examples{
example(build_domino, echo = FALSE)
#basic usage
signaling_heatmap(pbmc_dom_built_tiny)
#scale
signaling_heatmap(pbmc_dom_built_tiny, scale = "sqrt")
#normalize
signaling_heatmap(pbmc_dom_built_tiny, normalize = "rec_norm")

}
