% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fxns.R
\name{circos_ligand_receptor}
\alias{circos_ligand_receptor}
\title{Plot expression of a receptor's ligands by other cell types as a chord plot}
\usage{
circos_ligand_receptor(
  dom,
  receptor,
  ligand_expression_threshold = 0.01,
  cell_idents = NULL,
  cell_colors = NULL
)
}
\arguments{
\item{dom}{Domino object that has undergone network building with \code{\link[=build_domino]{build_domino()}}}

\item{receptor}{Name of a receptor active in at least one cell type in the domino object}

\item{ligand_expression_threshold}{Minimum mean expression value of a ligand by a cell type for a chord to be rendered between the cell type and the receptor}

\item{cell_idents}{Vector of cell types from cluster assignments in the domino object to be included in the plot.}

\item{cell_colors}{Named vector of color names or hex codes where names correspond to the plotted cell types and the color values}
}
\value{
Renders a circos plot to the active graphics device
}
\description{
Creates a chord plot of expression of ligands that can activate a specified
receptor where chord widths correspond to mean ligand expression by the cluster.
}
\examples{
example(build_domino, echo = FALSE)
#basic usage
circos_ligand_receptor(pbmc_dom_built_tiny, receptor = "CXCR3")
#specify colors
cols = c("red", "orange", "green")
names(cols) = dom_clusters(pbmc_dom_built_tiny)
circos_ligand_receptor(pbmc_dom_built_tiny, receptor = "CXCR3", cell_colors = cols)

}
