% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations_entropy.R
\name{entropy}
\alias{entropy}
\title{Compute Shannon Entropy on row-normalized data}
\usage{
entropy(x, assay_name = NULL, new_assay_name = "Entropy")
}
\arguments{
\item{x}{A data.frame (with numeric columns)
or a SummarizedExperiment (with an assay of numeric data).}

\item{assay_name}{(SummarizedExperiment only) The name of the assay
to transform and compute Entropy on. If NULL, uses the first assay.}

\item{new_assay_name}{If you prefer to store Q-values in a
*new* assay, provide a name. By default 'Entropy'}
}
\value{
\itemize{
  \item If \code{x} is a data.frame: returns the same data.frame in which
    numeric columns have been replaced by their row-wise proportions,
    and an \code{Entropy} column is appended.
  \item If \code{x} is a SummarizedExperiment: returns the same
    SummarizedExperiment in with a new assay (Default name is \code{Entropy})
    and \code{rowData(x)$Entropy} is added.
    }
}
\description{
Compute Shannon Entropy on row-normalized data
}
\examples{
library(SummarizedExperiment)
library(airway)
data('airway')

se = airway

# Only use a random subset of 1000 rows
set.seed(123)
idx <- sample(seq_len(nrow(se)), size = min(1000, nrow(se)))
se <- se[idx, ]

# -------------------------------
# 1) Using a data.frame
# -------------------------------
df = assay(se) |> as.data.frame()
df = entropy(df)

## The function adds a new column called Entropy and transform all
## the counts accordingly
head(df)

# -------------------------------
# 2) Using a SummarizedExperiment
# -------------------------------

## The function adds a new assay called 'Entropy' with the transformed
## counts.
## This name can be modified with the 'new_assay_name' parameter
## In the rowData dataframe a new column called Entropy is added.
se2 <- entropy(se, new_assay_name = 'Entropy')
se2

## In case the experiment has multiple assays, the function allows you to
## choose which assay to use.
new_matrix =  matrix(data = sample(x = seq(1, 100000),
                                   size = nrow(se) * ncol(se),
                                   replace = TRUE),
                     nrow = nrow(se),
                     ncol = ncol(se))
rownames(new_matrix) = rownames(se)
colnames(new_matrix) = colnames(se)

## Creating a new assay called new counts
assay(se, 'new_counts') = new_matrix


## Saving the entropy values as Entropy_newmatrix using the assay 'new
## counts'
se2 = entropy(se,
              new_assay_name = 'Entropy_newmatrix',
              assay_name = 'new_counts')

se2

}
