% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simDMRs.R
\name{simDMRs}
\alias{simDMRs}
\title{Simulate Differentially Methylated Regions}
\usage{
simDMRs(bs, num.dmrs = 3000, delta.max0 = 0.3)
}
\arguments{
\item{bs}{a BSseq object containing only control samples (from the same
population) for which simulated DMRs will be added after dividing the 
population into two artificial groups.}

\item{num.dmrs}{an integer specifying how many DMRs to add.}

\item{delta.max0}{a proportion value indicating the mode value for the
difference in proportion of methylated CpGs in the simulated DMRs (the
actual value will be drawn from a scaled Beta distribution centered at 
this value). Default value is 0.3.}
}
\value{
A named list object with 5 elements: (1) 
\code{gr.dmrs} is a \code{GRanges} object with \code{num.dmrs}
ranges that represent the random DMRs added. (2) \code{dmr.mncov} is a 
numeric vector that contains the mean coverage in each simulated DMR. (3)
\code{dmr.L} is a numeric vector that contains the number of CpGs in each 
simulated DMR. (4) \code{bs} is the BSseq object that contains the 
simulated DMRs. (5) \code{deltas} is a numeric vector that contains the 
effect size used for each DMR.
}
\description{
Add simulated DMRs to observed control data. Control data will be split
into two (artificial) populations.
}
\examples{

# Add simulated DMRs to a BSseq dataset
# This is just for illustrative purposes - ideally you would
# add DMRs to a set of samples from the same condition (in our
# example data, we have data from two different cell types)
# In this case, we shuffle the samples by cell type to create
# a null comparison.

data(BS.chr21)

BS.chr21.sim <- simDMRs(bs=BS.chr21[1:10000,c(1,3,2,4)], 
                        num.dmrs=50)

# show the simulated DMRs GRanges object
show(BS.chr21.sim$gr.dmrs)

# show the updated BSseq object that includes the simulated DMRs
show(BS.chr21.sim$bs)

# examine effect sizes of the DMRs
head(BS.chr21.sim$delta)

}
