% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneLevel.R
\name{geneLevelStats}
\alias{geneLevelStats}
\title{geneLevelStats}
\usage{
geneLevelStats(
  se,
  coef = NULL,
  excludeTypes = NULL,
  includeTypes = NULL,
  returnSE = TRUE,
  minDensityRatio = 0.1,
  minWidth = 20,
  excludeGeneAmbiguous = TRUE
)
}
\arguments{
\item{se}{A `RangedSummarizedExperiment` containing the results of one of
the DEU wrappers.}

\item{coef}{The coefficients tested (if the model included more than one
term).}

\item{excludeTypes}{Vector of bin types to exclude.}

\item{includeTypes}{Vector of bin types to include (overrides
`excludeTypes`)}

\item{returnSE}{Logical; whether to return the updated `se` object
(default), or the gene-level table.}

\item{minDensityRatio}{Minimum ratio of read density (with respect to the 
gene's average) for a bin to be included.}

\item{minWidth}{Minimum bin width to include}

\item{excludeGeneAmbiguous}{Logical; whether to exclude bins which are 
ambiguous (i.e. can be from different genes)}
}
\value{
If `returnSE=TRUE` (default), returns the `se` object with an
updated `metadata(se)$geneLevel` slot, otherwise returns the gene-level
data.frame.
}
\description{
Aggregates bin-level statistics to the gene-level
}
\examples{
library(SummarizedExperiment)
data(example_bin_se)
se <- diffSpliceWrapper(example_bin_se, ~condition)
se <- geneLevelStats(se, includeTypes="3UTR")
head(metadata(se)$geneLevel)
}
