% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vennRegions.R
\name{vennRegions}
\alias{vennRegions}
\title{Venn diagram for annotated regions given the genomic state}
\usage{
vennRegions(annotatedRegions, subsetIndex = NULL, ...)
}
\arguments{
\item{annotatedRegions}{The output from \link[derfinder:annotateRegions]{annotateRegions}
used on \code{regions}.}

\item{subsetIndex}{A vector of to use to subset the regions to use for the
venn diagram. It can be a logical vector of length equal to the number of
regions or an integer vector. If \code{NULl}, then it's ignored.}

\item{...}{Arguments passed to \link[limma:venn]{vennDiagram}.}
}
\value{
Makes a venn diagram plot for the annotation given the genomic state
and the actual venn counts used to make the plot.
}
\description{
Makes a venn diagram for the regions given the genomic state showing how many
regions overlap introns, exons, intergenic regions, none or multiple groups.
}
\examples{
## Load data
library("derfinder")

## Annotate regions
annotatedRegions <- annotateRegions(
    regions = genomeRegions$regions,
    genomicState = genomicState$fullGenome, minoverlap = 1
)

## Make venn diagram
venn <- vennRegions(annotatedRegions)

## Add title and choose text color
venn2 <- vennRegions(annotatedRegions,
    main = "Venn diagram", counts.col =
        "blue"
)

## Subset to only significant regions, so you don't have to annotate them
## again
venn3 <- vennRegions(annotatedRegions,
    subsetIndex =
        genomeRegions$regions$significant == "TRUE", main = "Significant only"
)
}
\seealso{
\link[derfinder:annotateRegions]{annotateRegions}, \link[limma:venn]{vennCounts},
\link[limma:venn]{vennDiagram}
}
\author{
Leonardo Collado-Torres
}
