% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{dmmSimulateHto}
\alias{dmmSimulateHto}
\alias{dmmSimulateHto,matrix-method}
\title{Simulate HTO sequencing data}
\usage{
dmmSimulateHto(
  class,
  mu = 180,
  theta = 15,
  muAmbient = 30,
  thetaAmbient = 10,
  muRna = 3000,
  thetaRna = 30
)
}
\arguments{
\item{class}{A \code{matrix} of type logical defining the number of
HTOs, the number of droplets, and the droplets' class memberships, i.e.,
which droplets contain cells that have been tagged with a certain HTO.
Each row corresponds to one HTO and each column to a droplet. Negative
droplets (all entries in the column are \code{FALSE}) and multiplets
(more than one entry are \code{TRUE}) are allowed. If the matrix has row
names, the names must be unique and are used as HTO names.}

\item{mu}{Vector of expectation values of the HTO counts if a
droplet is positive for the HTO. Values are recycled if \code{mu} is
shorter than number of HTOs defined by \code{class}.}

\item{theta}{Vector of dispersion parameters of the HTO counts if a
droplet is positive for the HTO. Values are recycled if \code{theta} is
shorter than number of HTOs defined by \code{class}.}

\item{muAmbient}{Vector of expectation values of the HTO counts if a
droplet is negative for the HTO. Values are recycled if \code{mu} is
shorter than number of HTOs defined by \code{class}.}

\item{thetaAmbient}{Vector of dispersion parameters of the HTO counts if a
droplet is negative for the HTO. Values are recycled if \code{theta} is
shorter than number of HTOs defined by \code{class}.}

\item{muRna}{Single expectation value for the number of detected RNA
features.}

\item{thetaRna}{Single dispersion parameter for the number of detected RNA
features.}
}
\value{
A list with three elements: \code{hto} is a matrix of the same
  dimension as the given \code{class} matrix and contains the simulated HTO
  counts. \code{rna} is a vector of simulated detected number of genes (same
  length as \code{hto} has columns). \code{groundTruth} is a character
  vector encoding the class labels given by \code{class} as character
  strings for convenience.
}
\description{
This method simulates HTO count data and corresponding numbers of detected
RNA features using the negative binomial distribution. The purpose of this
method is to provide simple example datasets for testing and documentation.
}
\details{
A vector \eqn{r} of detected RNA features (same length as columns
  in \code{class}) is simulated using \code{\link[stats]{rnbinom}} with
  \code{muRna} and \code{thetaRna} as parameters. HTO counts of positive
  droplets are then simulated using \code{\link[stats]{rnbinom}} with 
  \eqn{r} \code{mu}/\code{muRna} as expectation value and \code{theta}
  as dispersion. If a droplet is negative for the HTO,
  \eqn{r} \code{muAmbient}/\code{muRna} and \code{thetaAmbient}
  are used respectively.
}
\examples{
set.seed(2642)
class <- rbind(c(rep(TRUE, 220), rep(FALSE, 200)),
               c(rep(FALSE, 200), rep(TRUE, 220)))
simdata <- dmmSimulateHto(class = class, mu = c(150, 300), theta = c(15, 20),
                          muAmbient = c(30, 30), thetaAmbient = c(10, 10),
                          muRna = 3000, thetaRna = 30)
dim(simdata$hto)
table(simdata$groundTruth)

mean(simdata$rna) # muRna
var(simdata$rna)  # muRna + muRna^2/thetaRna

mean(simdata$hto[1, class[1, ]])  # mu[1]
mean(simdata$hto[1, !class[1, ]]) # muAmbient[1]
var(simdata$hto[1, class[1, ]])   # > mu[1] + mu[1]^2/theta[1]


cor(simdata$rna[class[1, ]], simdata$hto[1, class[1, ]])

}
\seealso{
\code{\link{demuxmix}}
}
