% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions_for_class_checks.R
\name{sameSignatureFormat}
\alias{sameSignatureFormat}
\title{sameSignatureFormat}
\usage{
sameSignatureFormat(x, y)
}
\arguments{
\item{x}{First object to be checked.}

\item{y}{Second object to be checked.}
}
\value{
Logical value (true or false).
}
\description{
`sameSignatureFormat()` checks whether two input object are sets (lists) of
numeric objects both compatible with the same signature format (probability
vectors for Alexandrov signatures and probability matrices or data.frames
for Shiraishi signatures). For Shiraishi signatures also the number of
flanking bases and the presence of transcription-strand information are
compared. For Alexandrov signatures also the number of triplet changes are
compared.
}
\examples{

### get Alexandrov signatures from COSMIC
signAlexandrov <- readAlexandrovSignatures()

### convert them to the Shiraishi model
signShiraishi <- convertAlexandrov2Shiraishi(signAlexandrov)

sameSignatureFormat(signAlexandrov, signShiraishi)
}
\references{
\url{http://rmpiro.net/decompTumor2Sig/}\cr
Krueger, Piro (2019) decompTumor2Sig: Identification of mutational
signatures active in individual tumors. BMC Bioinformatics
20(Suppl 4):152.\cr
}
\seealso{
\code{\link{decompTumor2Sig}}\cr
\code{\link{isAlexandrovSet}}\cr
\code{\link{isShiraishiSet}}
}
\author{
Rosario M. Piro\cr Politecnico di Milano\cr Maintainer: Rosario
M. Piro\cr E-Mail: <rmpiro@gmail.com> or <rosariomichael.piro@polimi.it>
}
