% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMutationDistribution.R
\name{plotMutationDistribution}
\alias{plotMutationDistribution}
\title{Plot mutation frequency data of a mutational signature or tumor genome.}
\usage{
plotMutationDistribution(mutData, colors = NULL, strip = NULL)
}
\arguments{
\item{mutData}{(Mandatory) The signature or genome mutation frequency data
to be plotted. This can either be a matrix (Shiraishi model) or a
numeric vector (Alexandrov model).}

\item{colors}{Vector of colors to be used for the base change data. For
Alexandrov-type data, this vector must contain six elements (one per base
change). For Shiraishi-type data, this vector must contain four elements
(one per base). If \code{NULL} (default), for Alexandrov-type data, the
colors are set to those used by the COSMIC website; for Shiraishi-type
data, the consensus base colors for sequence logos will be used.}

\item{strip}{Background color for strip labels; used only for
Alexandrov-type data. If \code{NULL} (default), "papayawhip" will be used.}
}
\value{
Returns (or draws) a plot according to the Alexandrov or Shiraishi
model of mutational signatures.
}
\description{
`plotMutationDistribution()` plots a single signature or the mutation
frequency data for a single genome. This works for signatures or genome
data of both the Shiraishi and the Alexandrov type.
}
\examples{

### Attention: using plotMutationDistribution requires the package
### pmsignature to be installed!


### get Alexandrov signatures from COSMIC
signatures <- readAlexandrovSignatures()

### plot the first Alexandrov signature
plotMutationDistribution(signatures[[1]])

### read four Shiraishi signatures for breast cancer genomes from 
### Nik-Zainal et al (PMID: 22608084) from flat files
sigfiles <- system.file("extdata",
         paste0("Nik-Zainal_PMID_22608084-pmsignature-sig",1:4,".tsv"),
         package="decompTumor2Sig")
signatures <- readShiraishiSignatures(sigfiles)

### plot the first Shiraishi signature
plotMutationDistribution(signatures[[1]])

}
\references{
\url{http://rmpiro.net/decompTumor2Sig/}\cr
Krueger, Piro (2019) decompTumor2Sig: Identification of mutational
signatures active in individual tumors. BMC Bioinformatics
20(Suppl 4):152.\cr
}
\seealso{
\code{\link{decompTumor2Sig}}
}
\author{
Rosario M. Piro\cr Politecnico di Milano\cr Maintainer: Rosario
M. Piro\cr E-Mail: <rmpiro@gmail.com> or <rosariomichael.piro@polimi.it>
}
