% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downgradeShiraishiSignatures.R
\name{downgradeShiraishiSignatures}
\alias{downgradeShiraishiSignatures}
\title{Downgrade Shiraishi-type signatures.}
\usage{
downgradeShiraishiSignatures(signatures, numBases=NULL,
removeTrDir=FALSE)
}
\arguments{
\item{signatures}{(Mandatory) A list of Shiraishi signatures that need to be
downgraded/trimmed.}

\item{numBases}{(Conditionally optional) The total number of bases
(mutated base plus flanking bases around the mutated base) that should
be kept. All further flanking bases farther away from the mutated bases
are dropped. If specified, \code{numBases} must be odd and smaller than
the current number of bases of the \code{signatures}. If \code{NULL}, no
flanking bases will be dropped. At least one of \code{numBases} or
\code{removeTrDir} must be specified.}

\item{removeTrDir}{(Conditionally optional) Logical value that specifies
whether information on the transcript direction should be dropped (if
present at all). At least one of \code{numBases} or \code{removeTrDir}
must be specified.}
}
\value{
A list of Shiraishi signatures that have been accordingly downgraded.
}
\description{
`downgradeShiraishiSignatures()` downgrades/trims signatures of the
Shiraishi type by discarding flanking bases (reducing the length of the
sequence pattern) and/or the transcription direction. The downgrade doesn't
pose a problem because the flanking bases and the transcription direction
are considered as independent features according to the Shiraishi model of
mutational signatures.
}
\examples{

### Load 15 Shiraishi signatures obtained from 435 tumor genomes from
### Alexandrov et al. (number of bases: 5, transcription direction: yes)
sfile <- system.file("extdata",
         "Alexandrov_PMID_23945592_435_tumors-pmsignature-15sig.Rdata", 
         package="decompTumor2Sig")
load(sfile)

### downgrade the signatures to include only 3 bases and drop the
### transcription direction 
downgradeShiraishiSignatures(signatures, numBases=3, removeTrDir=TRUE)

}
\references{
\url{http://rmpiro.net/decompTumor2Sig/}\cr
Krueger, Piro (2019) decompTumor2Sig: Identification of mutational
signatures active in individual tumors. BMC Bioinformatics 
20(Suppl 4):152.\cr
}
\seealso{
\code{\link{decompTumor2Sig}}
}
\author{
Rosario M. Piro\cr Politecnico di Milano\cr Maintainer: Rosario
M. Piro\cr E-Mail: <rmpiro@gmail.com> or <rosariomichael.piro@polimi.it>
}
