% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composeGenomesFromExposures.R
\name{composeGenomesFromExposures}
\alias{composeGenomesFromExposures}
\title{Compose tumor genomes from exposures.}
\usage{
composeGenomesFromExposures(exposures, signatures)
}
\arguments{
\item{exposures}{(Mandatory) A single vector or list of vectors containing
the estimated signature contributions/exposures as computed by the function
\code{decomposeTumorGenomes}. A list of vectors is used if the
(re-)composition shall be performed for multiple genomes. The number of
elements of each exposure vector must correspond to the number of
\code{signatures}.}

\item{signatures}{(Mandatory) The list of signatures (vectors, data frames
or matrices) for which the exposures were obtained. Each of the list
objects represents one mutational signature. Vectors are used for
Alexandrov signatures, data frames or matrices for Shiraishi signatures.}
}
\value{
A list of "predicted" genomes, i.e., the frequencies of their
mutational patterns computed as weighted sums of the mutational signatures,
where the weights correspond to the contributions of, i.e., exposures to,
the corresponding signatures.
}
\description{
`composeGenomesFromExposures()` re-composes (or predicts) tumor genomes
(i.e., their mutation frequencies) from the given mutational signatures and
their corresponding exposures, or contributions. The (re-)composition is
performed by computing the weighted sum of the mutational signatures, where
the weights are the exposures (=contributions) of the corresponding
signatures. This can, for example, be used to verify that a decomposition
obtained from \code{decomposeTumorGenomes} is meaningful.
}
\examples{

### get Alexandrov signatures from COSMIC
signatures <- readAlexandrovSignatures()

### load preprocessed breast cancer genomes (object 'genomes') from
### Nik-Zainal et al (PMID: 22608084) 
gfile <- system.file("extdata",
         "Nik-Zainal_PMID_22608084-genomes-Alexandrov_3bases.Rdata", 
         package="decompTumor2Sig")
load(gfile)

### compute exposures
exposures <- decomposeTumorGenomes(genomes, signatures, verbose=FALSE)

### re-compose (predict) tumor genome features from exposures
predGenomes <- composeGenomesFromExposures(exposures, signatures)

}
\references{
\url{http://rmpiro.net/decompTumor2Sig/}\cr
Krueger, Piro (2019) decompTumor2Sig: Identification of mutational
signatures active in individual tumors. BMC Bioinformatics 
20(Suppl 4):152.\cr
}
\seealso{
\code{\link{decompTumor2Sig}}\cr
\code{\link{decomposeTumorGenomes}}
}
\author{
Rosario M. Piro\cr Politecnico di Milano\cr Maintainer: Rosario
M. Piro\cr E-Mail: <rmpiro@gmail.com> or <rosariomichael.piro@polimi.it>
}
