% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions_for_sequences.R
\name{compNucFreq}
\alias{compNucFreq}
\title{Compute nucleotide frequencies (internal function)}
\usage{
compNucFreq(refGenome, regions=NULL, numBases=1, mergeByRevComp=TRUE)
}
\arguments{
\item{refGenome}{Reference genome (\code{BSgenome})}

\item{regions}{(Optional) Regions (\code{GRanges}); default:
\code{NULL} (whole genome).}

\item{numBases}{(Optional) Sequence pattern length for which to compute
frequencies (e.g., '3' for trinucleotides). Default: 1 (single nucleotides).}

\item{mergeByRevComp}{(Optional) Reduce redundancy by merging counts
for reverse complement sequence patterns. This function allows this only
for sequence patterns with odd length (e.g., single nucleotides,
trinucleotides). Default: \code{TRUE}.}
}
\value{
Vector of computed nucleotide frequencies
}
\description{
Compute nucleotide frequencies for a reference genome and a region set.
}
\references{
\url{http://rmpiro.net/decompTumor2Sig/}\cr
Krueger, Piro (2019) decompTumor2Sig: Identification of mutational
signatures active in individual tumors. BMC Bioinformatics
20(Suppl 4):152.\cr
}
\author{
Rosario M. Piro\cr Politecnico di Milano\cr Maintainer: Rosario
M. Piro\cr E-Mail: <rmpiro@gmail.com> or <rosariomichael.piro@polimi.it>
}
\keyword{internal}
